//
//  OldItemGroupSupport.swift
//  Do It
//
//  Created by Jim Dovey on 2/14/20.
//  Copyright © 2020 Jim Dovey. All rights reserved.
//

import Foundation

extension TodoItemGroup {
    func items(from data: DataCenter) -> [TodoItemStruct] {
        switch self {
        case .today:
            return todayItems(data.todoItems)
        case .scheduled:
            return scheduledItems(data.todoItems)
        case .overdue:
            return overdueItems(data.todoItems)
        case .all:
            return data.todoItems
        }
    }

    private func todayItems(_ items: [TodoItemStruct]) -> [TodoItemStruct] {
        let todayComponents = Calendar.current
            .dateComponents([.day, .month, .year], from: Date())
        let today = Calendar.current.date(from: todayComponents)!
        let interval = DateInterval(start: today, duration: 60 * 60 * 24)

        return items.filter {
            $0.date != nil && interval.contains($0.date!)
        }
    }

    private func scheduledItems(_ items: [TodoItemStruct]) -> [TodoItemStruct] {
        items.filter { $0.date != nil && !$0.complete }
    }

    private func overdueItems(_ items: [TodoItemStruct]) -> [TodoItemStruct] {
        items.filter {
            $0.complete == false && $0.date != nil && $0.date! < Date()
        }
    }
}
